import java.io.*;
import java.net.*;
import javax.net.ssl.*;
import java.security.*;

public class SSLClient {

    private static final int SSL_PORT =4711;
    private static final String SERVER_NAME = "localhost";

    public static void main (String[] args){
	try{
		System.out.print("\nWelcome to SSLClient!");

		// zuvor erstellten Keystore aus Datei laden
		KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
		char[] passphrase = "passwort".toCharArray();
		keystore.load(new FileInputStream("keystore"), passphrase);

		// TrustManager-Liste mittels Default-TrustManagerFactory erstellen und mit KeyStrore initialisieren
		TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
		tmf.init(keystore);
		TrustManager[] trustManagers = tmf.getTrustManagers();

		// SSLContext erstellen und mit TrustManager-Liste initialisieren
		SSLContext context = SSLContext.getInstance("TLS");
		context.init(null, trustManagers, null);

		// aus SSLContext SSLSocketFactory erstellen und SSLSocket (ber Socket) generieren lassen
		SSLSocketFactory ssf = (SSLSocketFactory) context.getSocketFactory();
		Socket defaultSocket = new Socket(SERVER_NAME, SSL_PORT);
		SSLSocket sslSocket = (SSLSocket) ssf.createSocket(defaultSocket, SERVER_NAME, SSL_PORT, true);

		System.out.print("\nSSL Connection successfully established!");

		// Datenbertragung
		DataOutputStream out = new DataOutputStream(sslSocket.getOutputStream());
		DataInputStream in = new DataInputStream(sslSocket.getInputStream());
                String[] transmit = {"Das Pferd frisst keinen Gurkensalat.",
                                      "Ein kleiner Schritt fuer SSL, aber ein grosser Schritt fuer die TB.",
				      "Denken Sie, wie schn der Krieger, der die Botschaft, die den Sieg, den die Athener bei Marathon, obwohl sie in der Minderheit waren, nach Athen, das in grosser Sorge, ob es die Perser nicht zerstren wrden, schwebte, erfochten hatten, verkndete, brachte, starb!",
				      "endetext"};

                for(int i=0; i<transmit.length; i++){
                  System.out.print("\n\nTransmitting: " + transmit[i]);
                  out.writeUTF(transmit[i]);
                  out.flush();
                  System.out.print("\n --> Server answered: " + in.readUTF() );
                  System.out.print("\n----------------------------------");
                }//for

		// Verbindungen beenden
		out.close();
		sslSocket.close();
		defaultSocket.close();

		System.out.print("\n\nConnection closed, now leaving SSLClient!");
		System.out.print("\n\n");
	}//try

	catch(Exception e){// Ausnahmebehandlung
	    System.out.print("\n\nAn Exception occured!");
	    System.out.print("\nException Class: "        + e.getClass() );
	    System.out.print("\nException Cause: "        + e.getCause() );
	    System.out.print("\nException Message: "      + e.getMessage() );
	    System.out.print("\nException Stacktrace: \n");
            e.printStackTrace();
	    System.out.print("\nEnd of Stacktrace: \n\n");
	}//catch

    } //main()
}// class
