import java.io.*;
import java.net.*;
import javax.net.ssl.*;
import java.security.*;

public class SSLServer{

    private static final int SSL_PORT_SERVER = 4711;

    public static void main(String[] args){
	try{
	    System.out.print("\nWelcome to SSLServer!");

	    // zuvor erstellten Keystore aus Datei laden
	    KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
	    char[] passphrase = "passwort".toCharArray();
	    keystore.load(new FileInputStream("keystore"), passphrase);

	    // KeyManager-Liste mittels Default-KeyManagerFactory erstellen und mit KeyStrore initialisieren
	    KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
	    kmf.init(keystore, passphrase);
	    KeyManager[] keyManagers = kmf.getKeyManagers();

	    // SSLContext erstellen und mit KeyManager-Liste initialisieren
	    SSLContext context = SSLContext.getInstance("TLS");
	    context.init(keyManagers, null, null);

	    // aus SSLContext SSLServerSocketFactory erstellen und SSLServerSocket generieren lassen
	    SSLServerSocketFactory ssf = (SSLServerSocketFactory) context.getServerSocketFactory();
	    SSLServerSocket socket = (SSLServerSocket) ssf.createServerSocket(SSL_PORT_SERVER);

	    // ber SSLSocket auf eingehende Verbindung warten und akzeptieren
	    Socket acceptedSocket = socket.accept();

	    System.out.print("\nSSL Connection successfully established!");

	    // Datenbertragung
	    DataInputStream in = new DataInputStream(acceptedSocket.getInputStream());
	    DataOutputStream out = new DataOutputStream(acceptedSocket.getOutputStream());
	    String received;

	    do{
		received = in.readUTF();
		System.out.print("\n\nReceived: "+ received);
                out.writeUTF("Confirming: " + received);
	    }while(! received.equals("endetext"));

	    // Verbindungen beenden
	    in.close();
	    acceptedSocket.close();
	    socket.close();
	    System.out.print("\nConnection closed, now leaving SSLServer!");
	    System.out.print("\n\n");
	}//try

	catch(Exception e){// Ausnahmebehandlung
	    System.out.print("\n\nAn Exception occured!");
	    System.out.print("\nException Class: "        + e.getClass() );
	    System.out.print("\nException Cause: "        + e.getCause() );
	    System.out.print("\nException Message: "      + e.getMessage() );
	    System.out.print("\nException Stacktrace: \n");
            e.printStackTrace();
	    System.out.print("\nEnd of Stacktrace: \n\n");
	}//catch
    }// main()
}// class

